USE OLAP
--The NTILE() function 
SELECT product,product_cost
       ,NTILE(5) OVER(order by product_cost desc) as ranking
	    --1 star=most expensive,5 stars=cheapest
FROM products
ORDER BY product_cost

--Visualising NTILE data
SELECT product,product_cost
       ,CASE NTILE(5) OVER(order by product_cost desc) 
	         WHEN 5 THEN '* * * * *'
	         WHEN 4 THEN '* * * *'
			 WHEN 3 THEN '* * *'
			 WHEN 2 THEN '* *'
			 WHEN 1 THEN '*'
		END as ranking
	    --1 star=most expensive,5 stars=cheapest
FROM products
ORDER BY product_cost